function ssfp = ssfp_signal(T1, T2, TR, alpha_deg, Phi_rad, RF_phase_deg)
% alpha_deg = flip angle in deg.
% Phi_rad = phase angle in radians over which to calculate the signal.
% RF_phase_deg = RF phase, deg.
% ssfp is a column vector.
% =====================================================================
if nargin < 6
    RF_phase_deg = 0;
end
E1 = exp(-TR/T1); E2 = exp(-TR/T2);
a = -(1 - E1)*E2*sind(alpha_deg);
b = (1 - E1)*sind(alpha_deg);
c = E2*(E1 - 1)*(1 + cosd(alpha_deg));
d = 1 - E1*cosd(alpha_deg) - (E1 - cosd(alpha_deg))*E2^2;
ssfp = exp(1j*(RF_phase_deg*pi/180 + pi/2))*(a*exp(1j*Phi_rad(:)) + b)./(c*cos(Phi_rad(:)) + d);
